<?php
if(!defined('IN_DISCUZ') || !defined('IN_ADMINCP')) {
	exit('Access Denied');
}

global $_G;

$type = $_GET['type'];
$plang = lang('plugin/unifiedpay');

require_once DISCUZ_ROOT . 'source/plugin/unifiedpay/function/function_base.php';

if($type == 'switch') {
	$alipaysettings = C::t('common_setting')->fetch_setting('ec_alipay', true);
	$wechatsettings = C::t('common_setting')->fetch_setting('ec_wechat', true);
	$qpaysettings = C::t('common_setting')->fetch_setting('ec_qpay', true);

	$plugins_list = C::t('common_setting')->fetch_setting('unifiedpay_plugins', true);
	if(!$plugins_list || count($plugins_list) < 3){
		$plugins_list = unifiedpay_plugin_refresh();
	}
	$alipay_plugins = [array('off', $plang['channel_select_off'], array())];
	$wechat_plugins = [array('off', $plang['channel_select_off'], array())];
	$qpay_plugins = [array('off', $plang['channel_select_off'], array())];
	foreach($plugins_list as $plugin) {
		if(in_array('alipay', $plugin['types'])) $alipay_plugins[] = array($plugin['name'], $plang['payment_plugin_'.$plugin['name']], array());
		if(in_array('wechat', $plugin['types'])) $wechat_plugins[] = array($plugin['name'], $plang['payment_plugin_'.$plugin['name']], array());
		if(in_array('qpay', $plugin['types'])) $qpay_plugins[] = array($plugin['name'], $plang['payment_plugin_'.$plugin['name']], array());
	}

	if(!submitcheck('submit')) {

		showtips($plang['payment_setting_tips']);
		showformheader('plugins&operation=config&do=2&identifier=unifiedpay&pmod=admincp_config&type=switch');

		showtableheader('', 'nobottom');
		showtitle($plang['channel_select_title']);

		showtagheader('tbody', 'switch_setting', true);

		$alipaysettings['channel'] = $alipaysettings['on'] && $alipaysettings['channel'] ? $alipaysettings['channel'] : 'off';
		showsetting($plang['channel_select_alipay_title'], array('channel_alipay', $alipay_plugins), $alipaysettings['channel'], 'mradio');

		$wechatsettings['channel'] = $wechatsettings['on'] && $wechatsettings['channel'] ? $wechatsettings['channel'] : 'off';
		showsetting($plang['channel_select_wechat_title'], array('channel_wechat', $wechat_plugins), $wechatsettings['channel'], 'mradio');

		$qpaysettings['channel'] = $qpaysettings['on'] && $qpaysettings['channel'] ? $qpaysettings['channel'] : 'off';
		showsetting($plang['channel_select_qpay_title'], array('channel_qpay', $qpay_plugins), $qpaysettings['channel'], 'mradio');

		showtagfooter('tbody');

		showsetting('ec_alipay_check', '', '',
			'<a href="' . ADMINSCRIPT . '?action=plugins&operation=config&do=2&identifier=unifiedpay&pmod=admincp_config&type=checkcredit" target="_blank">' . $lang['ec_alipay_checklink_credit'] . '</a><br />'
		);
		showtableheader('', 'notop');
		showsubmit('submit');
		showtablefooter();
		showformfooter();

	} else {
		$alipaysettings['on'] = $_GET['channel_alipay'] == 'off' ? 0 : 1;
		$alipaysettings['channel'] = $_GET['channel_alipay'];
		C::t('common_setting')->update_setting('ec_alipay', $alipaysettings);
		$wechatsettings['on'] = $_GET['channel_wechat'] == 'off' ? 0 : 1;
		$wechatsettings['channel'] = $_GET['channel_wechat'];
		C::t('common_setting')->update_setting('ec_wechat', $wechatsettings);
		$qpaysettings['on'] = $_GET['channel_qpay'] == 'off' ? 0 : 1;
		$qpaysettings['channel'] = $_GET['channel_qpay'];
		C::t('common_setting')->update_setting('ec_qpay', $qpaysettings);
		updatecache('setting');

		cpmsg($plang['channel_succeed'], 'action=plugins&operation=config&do=2&identifier=unifiedpay&pmod=admincp_config&type=switch', 'succeed');
	}

} elseif($type == 'list') {
	$plugins_list = C::t('common_setting')->fetch_setting('unifiedpay_plugins', true);
	if(!$plugins_list || count($plugins_list) < 3){
		$plugins_list = unifiedpay_plugin_refresh();
	}
	$tdstyles = array(
		'style="width: 150px;"',
		'style="width: 150px;"',
		'style="width: 90px;"',
		'style="width: 100px;"'
	);
	
	if(!submitcheck('submit')) {
		showformheader('plugins&operation=config&do=2&identifier=unifiedpay&pmod=admincp_config&type=list');
		showboxheader();
		showtableheader();
		showsubtitle(array($plang['ec_channel_list_name'], $plang['ec_channel_list_types'], $plang['ec_channel_list_link'], 'operation'));
		foreach($plugins_list as $row) {
			$typename = [];
			foreach($row['types'] as $type){
				$typename[] = $plang['payment_'.$type];
			}
			showtablerow('', $tdstyles, array(
				$plang['payment_plugin_'.$row['name']],
				implode(',',$typename),
				$row['link']?'<a href="'.$row['link'].'" target="_blank" rel="noreferrer">链接</a>':'链接',
				'<a href="' . ADMINSCRIPT . '?action=plugins&operation=config&do=2&identifier=unifiedpay&pmod=admincp_config&type='.$row['name'].'">配置密钥</a>',
			));
		}
		showsubmit('submit', $plang['ec_channel_list_refresh'], '', '<span class="tips2">'.$plang['ec_channel_list_refresh_comment'].'</span>');
		showtablefooter();
		showboxfooter();
		showformfooter();
	} else {
		unifiedpay_plugin_refresh();
		cpmsg('groups_setting_succeed', 'action=plugins&operation=config&do=2&identifier=unifiedpay&pmod=admincp_config&type=list', 'succeed');
	}
} elseif($type == 'checkcredit') {
	$return_url = $_G['siteurl'] . 'home.php?mod=spacecp&ac=credit';
	$pay_url = payment::create_order('payment_credit', $lang['ec_alipay_checklink_credit'], $lang['ec_alipay_checklink_credit'], 1, $return_url);
	ob_end_clean();
	dheader('location: ' . $pay_url);
	exit;

} elseif($type == 'alipay') {

	$alipaysettings = C::t('common_setting')->fetch_setting('unifiedpay_alipay', true);

	if(!submitcheck('alipaysubmit')) {

		showformheader('plugins&operation=config&do=2&identifier=unifiedpay&pmod=admincp_config&type=alipay', 'enctype');

		showtableheader('', 'nobottom');
		showtitle('ec_alipay');

		showtagheader('tbody', 'alipay_setting', true);

		showsetting($plang['alipay_product'], array('settingsnew[product]', array(
			array('1', $plang['alipay_product_1']),
			array('2', $plang['alipay_product_2']),
			array('3', $plang['alipay_product_3']),
			array('4', $plang['alipay_product_4']),
			array('5', $plang['alipay_product_5'])
		)), $alipaysettings['product'], 'mcheckbox2', '', 0, $plang['alipay_product_comment']);

		if(!$alipaysettings['cert_mode']) $alipaysettings['cert_mode'] = 0;
		showsetting('ec_alipay_sign_mode', array('settingsnew[cert_mode]', array(
			array(0, $lang['ec_alipay_sign_mode_01'], array('sign_model_01' => '', 'sign_model_02' => 'none')),
			array(1, $lang['ec_alipay_sign_mode_02'], array('sign_model_01' => 'none', 'sign_model_02' => '')),
		)), $alipaysettings['cert_mode'], 'mradio', '', 0, $plang['alipay_cert_mode_comment']);

		showsetting('ec_alipay_appid', 'settingsnew[app_id]', $alipaysettings['app_id'], 'text');
		showsetting($plang['alipay_app_private_key'], 'settingsnew[app_private_key]', $alipaysettings['app_private_key'], 'textarea');
		showtagfooter('tbody');

		showtagheader('tbody', 'sign_model_01', !$alipaysettings['cert_mode']);
		showsetting($plang['alipay_alipay_public_key'], 'settingsnew[alipay_public_key]', $alipaysettings['alipay_public_key'], 'textarea');
		showtagfooter('tbody');

		showtagheader('tbody', 'sign_model_02', $alipaysettings['cert_mode']);
		$file_status = '';
		if($alipaysettings['app_cert'] && file_exists(DISCUZ_ROOT.$alipaysettings['app_cert'])){
			$file_status = $plang['already_upload'];
			showhiddenfields(array('settingsnew[app_cert]' => $alipaysettings['app_cert']));
		}
		showsetting($plang['alipay_app_cert'], 'app_cert_file', '', 'file', '', 0, $file_status.$plang['alipay_app_cert_comment']);

		$file_status = '';
		if($alipaysettings['alipay_cert'] && file_exists(DISCUZ_ROOT.$alipaysettings['alipay_cert'])){
			$file_status = $plang['already_upload'];
			showhiddenfields(array('settingsnew[alipay_cert]' => $alipaysettings['alipay_cert']));
		}
		showsetting($plang['alipay_alipay_cert'], 'alipay_cert_file', '', 'file', '', 0, $file_status.$plang['alipay_alipay_cert_comment']);

		$file_status = '';
		if($alipaysettings['root_cert'] && file_exists(DISCUZ_ROOT.$alipaysettings['root_cert'])){
			$file_status = $plang['already_upload'];
			showhiddenfields(array('settingsnew[root_cert]' => $alipaysettings['root_cert']));
		}
		showsetting($plang['alipay_alipay_root_cert'], 'root_cert_file', '', 'file', '', 0, $file_status.$plang['alipay_alipay_root_cert_comment']);

		showtagfooter('tbody');

		showtableheader('', 'notop');
		showsubmit('alipaysubmit', 'submit', '', '&nbsp;&nbsp;&nbsp;&nbsp;<a href="' . ADMINSCRIPT . '?action=plugins&operation=config&do=2&identifier=unifiedpay&pmod=admincp_config&type=list">'.$lang['return'].'</a>');
		showtablefooter();
		showformfooter();

	} else {
		$settingsnew = $_GET['settingsnew'];
		if(!$settingsnew['product']){
			cpmsg_error($plang['alipay_setting_failed']);
		}
		if($settingsnew['cert_mode'] == 1){
			if(!is_dir(DISCUZ_ROOT.'data/cert')){
				mkdir(DISCUZ_ROOT.'data/cert');
			}
			if(isset($_FILES['app_cert_file']) && $_FILES['app_cert_file']['size'] > 0){
				$settingsnew['app_cert'] = !empty($settingsnew['app_cert']) ? $settingsnew['app_cert'] : 'data/cert/appCertPublicKey'.random(10).'.crt';
				move_uploaded_file($_FILES['app_cert_file']['tmp_name'], DISCUZ_ROOT.$settingsnew['app_cert']);
			}
			if(isset($_FILES['alipay_cert_file']) && $_FILES['alipay_cert_file']['size'] > 0){
				$settingsnew['alipay_cert'] = !empty($settingsnew['alipay_cert']) ? $settingsnew['alipay_cert'] : 'data/cert/alipayCertPublicKey'.random(10).'.crt';
				move_uploaded_file($_FILES['alipay_cert_file']['tmp_name'], DISCUZ_ROOT.$settingsnew['alipay_cert']);
			}
			if(isset($_FILES['root_cert_file']) && $_FILES['root_cert_file']['size'] > 0){
				$settingsnew['root_cert'] = !empty($settingsnew['root_cert']) ? $settingsnew['root_cert'] : 'data/cert/alipayRootCert.crt';
				move_uploaded_file($_FILES['root_cert_file']['tmp_name'], DISCUZ_ROOT.$settingsnew['root_cert']);
			}
		}
		$alipaysettings = [];
		foreach($settingsnew as $name => $value) {
			$alipaysettings[$name] = is_string($value) ? trim($value) : $value;
		}
		C::t('common_setting')->update_setting('unifiedpay_alipay', $alipaysettings);
		updatecache('setting');

		cpmsg('alipay_succeed', 'action=plugins&operation=config&do=2&identifier=unifiedpay&pmod=admincp_config&type=alipay', 'succeed');
	}

} elseif($type == 'wechat') {

	$wechatsettings = C::t('common_setting')->fetch_setting('unifiedpay_wechat', true);

	if(!submitcheck('wechatsubmit')) {

		showformheader('plugins&operation=config&do=2&identifier=unifiedpay&pmod=admincp_config&type=wechat', 'enctype');

		showtableheader('', 'nobottom');
		showtitle('ec_wechat');
		showtagheader('tbody', 'wechat_setting', true);

		showsetting($plang['wechat_product'], array('settingsnew[product]', array(
			array('1', $plang['wechat_product_1']),
			array('2', $plang['wechat_product_2']),
			array('3', $plang['wechat_product_3']),
			array('4', $plang['wechat_product_4'])
		)), $wechatsettings['product'], 'mcheckbox2', '', 0, $plang['wechat_product_comment']);

		if(!$wechatsettings['api_version']) $wechatsettings['api_version'] = 0;
		$selects = array(array(0, $plang['wechat_version_2'], array('api_version_2' => '', 'api_version_3' => 'none')));
		if(payment::get('wechat')->v3_wechat_support()) {
			$selects[] = array(1, $plang['wechat_version_3'], array('api_version_2' => 'none', 'api_version_3' => ''));
		}
		showsetting('ec_wechat_version', array('settingsnew[api_version]', $selects), $wechatsettings['api_version'], 'mradio');

		showsetting('ec_wechat_appid', 'settingsnew[appid]', $wechatsettings['appid'], 'text', '', 0, $plang['wechat_appid_comment']);
		showsetting('ec_wechat_appsecret', 'settingsnew[appsecret]', $wechatsettings['appsecret'], 'text', '', 0, $plang['wechat_appsecret_comment']);
		showsetting('ec_wechat_mch_id', 'settingsnew[mchid]', $wechatsettings['mchid'], 'text');
		showtagfooter('tbody');

		showtagheader('tbody', 'api_version_2', !$wechatsettings['api_version']);
		showsetting($plang['wechat_apikey'], 'settingsnew[apikey]', $wechatsettings['apikey'], 'text', '', 0, $plang['wechat_apikey_comment']);

		$file_status = '';
		if($wechatsettings['sslcert_path'] && file_exists(DISCUZ_ROOT.$wechatsettings['sslcert_path'])){
			$file_status = $plang['already_upload'];
			showhiddenfields(array('settingsnew[sslcert_path]' => $wechatsettings['sslcert_path']));
		}
		showsetting($plang['wechat_sslcert'], 'sslcert_file', '', 'file', '', 0, $file_status.$plang['wechat_sslcert_comment']);

		$file_status = '';
		if($wechatsettings['sslkey_path'] && file_exists(DISCUZ_ROOT.$wechatsettings['sslkey_path'])){
			$file_status = $plang['already_upload'];
			showhiddenfields(array('settingsnew[sslkey_path]' => $wechatsettings['sslkey_path']));
		}
		showsetting($plang['wechat_sslkey'], 'sslkey_file', '', 'file', '', 0, $file_status.$plang['wechat_sslkey_comment']);

		showtagfooter('tbody');

		showtagheader('tbody', 'api_version_3', $wechatsettings['api_version']);
		showsetting($plang['wechat_apiv3key'], 'settingsnew[apiv3key]', $wechatsettings['apiv3key'], 'text', '', 0, $plang['wechat_apiv3key_comment']);
		showsetting($plang['wechat_sslcert_serial'], 'settingsnew[sslcert_serial]', $wechatsettings['sslcert_serial'], 'text', '', 0, $plang['wechat_sslcert_serial_comment']);

		$file_status = '';
		if($wechatsettings['sslkey_path'] && file_exists(DISCUZ_ROOT.$wechatsettings['sslkey_path'])){
			$file_status = $plang['already_upload'];
			showhiddenfields(array('settingsnew[sslkey_v3_path]' => $wechatsettings['sslkey_path']));
		}
		showsetting($plang['wechat_sslkey_v3'], 'sslkey_v3_file', '', 'file', '', 0, $file_status.$plang['wechat_sslkey_v3_comment']);
		
		showsetting($plang['wechat_pubkey_id'], 'settingsnew[pubkey_id]', $wechatsettings['pubkey_id'], 'text', '', 0, $plang['wechat_pubkey_id_comment']);

		$file_status = '';
		if($wechatsettings['pubkey_path'] && file_exists(DISCUZ_ROOT.$wechatsettings['pubkey_path'])){
			$file_status = $plang['already_upload'];
			showhiddenfields(array('settingsnew[pubkey_v3_path]' => $wechatsettings['pubkey_path']));
		}
		showsetting($plang['wechat_pubkey_v3'], 'pubkey_v3_file', '', 'file', '', 0, $file_status.$plang['wechat_pubkey_v3_comment']);

		showtagfooter('tbody');

		showtagheader('tbody', 'wechat_mini_setting', true);
		showsetting($plang['wechat_miniappid'], 'settingsnew[miniappid]', $wechatsettings['miniappid'], 'text', '', 0, $plang['wechat_miniappid_comment']);
		showsetting($plang['wechat_miniappsecret'], 'settingsnew[miniappsecret]', $wechatsettings['miniappsecret'], 'text', '', 0, $plang['wechat_appsecret_comment']);
		showtagfooter('tbody');

		showtableheader('', 'notop');
		showsubmit('wechatsubmit', 'submit', '', '&nbsp;&nbsp;&nbsp;&nbsp;<a href="' . ADMINSCRIPT . '?action=plugins&operation=config&do=2&identifier=unifiedpay&pmod=admincp_config&type=list">'.$lang['return'].'</a>');
		showtablefooter();
		showformfooter();

	} else {
		$settingsnew = $_GET['settingsnew'];
		if(!$settingsnew['product']){
			cpmsg_error($plang['wechat_setting_failed']);
		}
		if(!is_dir(DISCUZ_ROOT.'data/cert')){
			mkdir(DISCUZ_ROOT.'data/cert');
		}
		if($settingsnew['api_version'] == 0 && isset($_FILES['sslcert_file']) && $_FILES['sslcert_file']['size'] > 0){
			$settingsnew['sslcert_path'] = !empty($settingsnew['sslcert_path']) ? $settingsnew['sslcert_path'] : 'data/cert/wechatMerchantCert'.random(10).'.pem';
			move_uploaded_file($_FILES['sslcert_file']['tmp_name'], DISCUZ_ROOT.$settingsnew['sslcert_path']);
		}
		if($settingsnew['api_version'] == 0 && isset($_FILES['sslkey_file']) && $_FILES['sslkey_file']['size'] > 0){
			$settingsnew['sslkey_path'] = !empty($settingsnew['sslkey_path']) ? $settingsnew['sslkey_path'] : 'data/cert/wechatMerchantKey'.random(10).'.pem';
			move_uploaded_file($_FILES['sslkey_file']['tmp_name'], DISCUZ_ROOT.$settingsnew['sslkey_path']);
		}
		if($settingsnew['api_version'] == 1 && isset($_FILES['sslkey_v3_file']) && $_FILES['sslkey_v3_file']['size'] > 0){
			$settingsnew['sslkey_path'] = !empty($settingsnew['sslkey_v3_path']) ? $settingsnew['sslkey_v3_path'] : 'data/cert/wechatMerchantKey'.random(10).'.pem';
			move_uploaded_file($_FILES['sslkey_v3_file']['tmp_name'], DISCUZ_ROOT.$settingsnew['sslkey_path']);
		}
		if($settingsnew['api_version'] == 1 && isset($_FILES['pubkey_v3_file']) && $_FILES['pubkey_v3_file']['size'] > 0){
			$settingsnew['pubkey_path'] = !empty($settingsnew['pubkey_v3_path']) ? $settingsnew['pubkey_v3_path'] : 'data/cert/wechatPublicKey'.random(10).'.pem';
			move_uploaded_file($_FILES['pubkey_v3_file']['tmp_name'], DISCUZ_ROOT.$settingsnew['pubkey_path']);
		}
		$settingsnew['platform_cert_path'] = 'data/cert/wechatPlatformCert.pem';
		unset($settingsnew['sslkey_v3_path']);
		$wechatsettings = [];
		foreach($settingsnew as $name => $value) {
			$wechatsettings[$name] = is_string($value) ? trim($value) : $value;
		}
		C::t('common_setting')->update_setting('unifiedpay_wechat', $wechatsettings);
		updatecache('setting');

		cpmsg('wechat_succeed', 'action=plugins&operation=config&do=2&identifier=unifiedpay&pmod=admincp_config&type=wechat', 'succeed');
	}

} elseif($type == 'qpay') {

	$qpaysettings = C::t('common_setting')->fetch_setting('unifiedpay_qpay', true);

	if(!submitcheck('qpaysubmit')) {

		showformheader('plugins&operation=config&do=2&identifier=unifiedpay&pmod=admincp_config&type=qpay', 'enctype');

		showtableheader('', 'nobottom');
		showtitle('ec_qpay');
		showtagheader('tbody', 'qpay_setting', true);
		showsetting('ec_qpay_jsapi', 'settingsnew[jsapi]', $qpaysettings['jsapi'], 'radio');

		showsetting('ec_qpay_mch_id', 'settingsnew[mchid]', $qpaysettings['mchid'], 'text');
		showsetting('ec_qpay_v1_key', 'settingsnew[apikey]', $qpaysettings['apikey'], 'text');

		showsetting('ec_qpay_appid', 'settingsnew[appid]', $qpaysettings['appid'], 'text');
		showsetting('ec_qpay_op_user_id', 'settingsnew[op_userid]', $qpaysettings['op_userid'], 'text');
		showsetting('ec_qpay_op_user_passwd', 'settingsnew[op_userpwd]', $qpaysettings['op_userpwd'], 'text');

		$file_status = '';
		if($qpaysettings['sslcert_path'] && file_exists(DISCUZ_ROOT.$qpaysettings['sslcert_path'])){
			$file_status = $plang['already_upload'];
			showhiddenfields(array('settingsnew[sslcert_path]' => $qpaysettings['sslcert_path']));
		}
		showsetting($plang['qpay_sslcert'], 'sslcert_file', '', 'file', '', 0, $file_status.$plang['qpay_sslcert_comment']);

		$file_status = '';
		if($qpaysettings['sslkey_path'] && file_exists(DISCUZ_ROOT.$qpaysettings['sslkey_path'])){
			$file_status = $plang['already_upload'];
			showhiddenfields(array('settingsnew[sslkey_path]' => $qpaysettings['sslkey_path']));
		}
		showsetting($plang['qpay_sslkey'], 'sslkey_file', '', 'file', '', 0, $file_status.$plang['qpay_sslkey_comment']);

		showtagfooter('tbody');

		showtableheader('', 'notop');
		showsubmit('qpaysubmit', 'submit', '', '&nbsp;&nbsp;&nbsp;&nbsp;<a href="' . ADMINSCRIPT . '?action=plugins&operation=config&do=2&identifier=unifiedpay&pmod=admincp_config&type=list">'.$lang['return'].'</a>');
		showtablefooter();
		showformfooter();

	} else {
		$settingsnew = $_GET['settingsnew'];
		if(isset($_FILES['sslcert_file']) && $_FILES['sslcert_file']['size'] > 0){
			$settingsnew['sslcert_path'] = !empty($settingsnew['sslcert_path']) ? $settingsnew['sslcert_path'] : 'data/cert/qpayMerchantCert'.random(10).'.pem';
			move_uploaded_file($_FILES['sslcert_file']['tmp_name'], DISCUZ_ROOT.$settingsnew['sslcert_path']);
		}
		if(isset($_FILES['sslkey_file']) && $_FILES['sslkey_file']['size'] > 0){
			$settingsnew['sslkey_path'] = !empty($settingsnew['sslkey_path']) ? $settingsnew['sslkey_path'] : 'data/cert/qpayMerchantKey'.random(10).'.pem';
			move_uploaded_file($_FILES['sslkey_file']['tmp_name'], DISCUZ_ROOT.$settingsnew['sslkey_path']);
		}
		$qpaysettings = [];
		foreach($settingsnew as $name => $value) {
			$qpaysettings[$name] = is_string($value) ? trim($value) : $value;
		}
		C::t('common_setting')->update_setting('unifiedpay_qpay', $qpaysettings);
		$qpay_switch = C::t('common_setting')->fetch_setting('ec_qpay', true);
		$qpay_switch['jsapi'] = intval($settingsnew['jsapi']);
		C::t('common_setting')->update_setting('ec_qpay', $qpay_switch);
		updatecache('setting');

		cpmsg('qpay_succeed', 'action=plugins&operation=config&do=2&identifier=unifiedpay&pmod=admincp_config&type=qpay', 'succeed');
	}

} elseif($type) {

	$info = unifiedpay_plugin_getinfo($type);
	if(!$info) {
		cpmsg_error($plang['payment_channel_not_exists']);
	}
	$paysettings = C::t('common_setting')->fetch_setting('unifiedpay_'.$type, true);

	if(!submitcheck($type.'submit')) {

		showformheader('plugins&operation=config&do=2&identifier=unifiedpay&pmod=admincp_config&type='.$type);

		showtableheader('', 'nobottom');
		showtitle($plang['payment_plugin_'.$type].$lang['config']);
		showtagheader('tbody', $type.'_setting', true);

		foreach($info['inputs'] as $key => $value) {
			if(isset($value['value']) && !isset($paysettings[$key])) $paysettings[$key] = $value['value'];
			$varname = 'settingsnew['.$key.']';
			if($value['type'] == 'mcheckbox' || $value['type'] == 'mradio'){
				$varname = array('settingsnew['.$key.']', $value['select']);
			}
			showsetting($plang[$value['name']] ?? $value['name'], $varname, $paysettings[$key], $value['type'], '', 0, $value['note'] ? $plang[$value['note']] : '');
		}
		showtagfooter('tbody');

		showtableheader('', 'notop');
		showsubmit($type.'submit', 'submit', '', '&nbsp;&nbsp;&nbsp;&nbsp;<a href="' . ADMINSCRIPT . '?action=plugins&operation=config&do=2&identifier=unifiedpay&pmod=admincp_config&type=list">'.$lang['return'].'</a>');
		showtablefooter();
		showformfooter();

	} else {
		$settingsnew = $_GET['settingsnew'];
		$paysettings = [];
		foreach($settingsnew as $name => $value) {
			$paysettings[$name] = is_string($value) ? trim($value) : $value;
		}
		C::t('common_setting')->update_setting('unifiedpay_'.$type, $paysettings);
		updatecache('setting');

		cpmsg($plang['channel_succeed'], 'action=plugins&operation=config&do=2&identifier=unifiedpay&pmod=admincp_config&type='.$type, 'succeed');
	}

}