<?php
if(!defined('IN_DISCUZ') || !defined('IN_ADMINCP')) {
	exit('Access Denied');
}

global $_G;

$plang = lang('plugin/unifiedpay');

require_once DISCUZ_ROOT . 'source/plugin/unifiedpay/function/function_base.php';

$qpaysettings = C::t('common_setting')->fetch_setting('unifiedpay_qpay', true);

if(!submitcheck('transfersubmit')) {

	showtips(lang('plugin/unifiedpay', 'ec_transfer_tips', array('siteurl'=>$_G['siteurl'])));
	showformheader('plugins&operation=config&do=2&identifier=unifiedpay&pmod=admincp_transfer', 'onsubmit="return confirm(\''.$plang['transfer_confirm'].'\')"', 'cpform" autocomplete="on');

	showtableheader('', 'nobottom');
	showtitle($plang['ec_transfer']);
	showtagheader('tbody', 'qpay_setting', true);

	showsetting($plang['transfer_channel'], array('transfer_channel', array(
		array('alipay', $plang['payment_alipay']),
		array('wechat', $plang['payment_wechat']),
		array('qpay', $plang['payment_qpay']),
	)), 'alipay', 'mradio');

	$transfer_no = dgmdate(TIMESTAMP, 'YmdHis') . random(6, 1);
	showsetting($plang['transfer_no'], 'transfer_no', $transfer_no, 'text', '', 0, $plang['transfer_no_comment']);
	showsetting($plang['transfer_account'], 'transfer_account', '', 'text', '', 0, $plang['transfer_account_comment']);
	showsetting($plang['transfer_name'], 'transfer_name', '', 'text', '', 0, $plang['transfer_name_comment']);
	showsetting($plang['transfer_money'], 'transfer_money', '', 'text', '', 0, $plang['transfer_money_comment']);
	showsetting($plang['transfer_remark'], 'transfer_remark', $_G['setting']['bbname'], 'text', '', 0, $plang['transfer_remark_comment']);
	showsetting($plang['transfer_uid'], 'transfer_uid', '1', 'text', '', 0, $plang['transfer_uid_comment']);

	showtagfooter('tbody');

	showtableheader('', 'notop');
	showsubmit('transfersubmit', $plang['transfer_submit']);
	showtablefooter();
	showformfooter();

} else {
	$transfer_no = $_GET['transfer_no'];
	$transfer_channel = $_GET['transfer_channel'];
	$transfer_account = $_GET['transfer_account'];
	$transfer_name = $_GET['transfer_name'];
	$transfer_money = $_GET['transfer_money'];
	$transfer_remark = $_GET['transfer_remark'];
	$transfer_uid = $_GET['transfer_uid'];
	if(empty($transfer_no) || empty($transfer_channel) || empty($transfer_account) || empty($transfer_money) || empty($transfer_remark)){
		cpmsg_error($plang['parameter_incomplete']);
	}
	if(!is_numeric($transfer_money) || !preg_match('/^[0-9.]+$/', $transfer_money) || $transfer_money == 0) {
		cpmsg_error($plang['transfer_amount_error']);
	}
	$subject = '';
	$description = '';
	if($transfer_channel == 'alipay') {
		$subject = $transfer_remark;
	}else{
		$description = $transfer_remark;
	}
	$result = unifiedpay_transfer($transfer_channel, $transfer_no, strval($transfer_money*100), $transfer_uid, $transfer_name, $transfer_account, $subject, $description);
	if($result['code'] == 200) {
		cpmsg('payment_transfer_succeed', 'action=ec&operation=transferorders&out_biz_no=' . $order['out_biz_no'], 'succeed');
	} else {
		cpmsg_error($result['message']);
	}
}
