<?php

/**
 *      [Discuz!] (C)2001-2099 Comsenz Inc.
 *      This is NOT a freeware, use is subject to license terms
 *
 *      $Id: payment_base.php 36342 2021-05-17 14:15:31Z dplugin $
 */

if(!defined('IN_DISCUZ')) {
	exit('Access Denied');
}

require_once DISCUZ_ROOT . 'source/plugin/unifiedpay/function/function_base.php';

class payment_base {

	var $plugin;

	public function __construct() {}

	protected function enable() {
		if($this->plugin) {
			return true;
		} else {
			return false;
		}
	}

	public function pay($order) {
		return unifiedpay_plugin_call($this->plugin, __FUNCTION__, func_get_args());
	}

	public function status($out_biz_no) {
		return unifiedpay_plugin_call($this->plugin, __FUNCTION__, func_get_args());
	}

	public function refund($refund_no, $trade_no, $total_amount, $refund_amount, $refund_desc) {
		return unifiedpay_plugin_call($this->plugin, __FUNCTION__, func_get_args());
	}

	public function refund_status($refund_no, $trade_no) {
		return unifiedpay_plugin_call($this->plugin, __FUNCTION__, func_get_args());
	}

	public function transfer($transfer_no, $amount, $realname, $account, $title = '', $desc = '') {
		return unifiedpay_plugin_call($this->plugin, __FUNCTION__, func_get_args());
	}

	public function transfer_status($transfer_no) {
		return unifiedpay_plugin_call($this->plugin, __FUNCTION__, func_get_args());
	}

	public function notify() {
		return unifiedpay_plugin_call($this->plugin, __FUNCTION__, func_get_args());
	}

}