<?php

/**
 *      [Discuz!] (C)2001-2099 Comsenz Inc.
 *      This is NOT a freeware, use is subject to license terms
 *
 *      $Id: payment_wechat.php 36342 2021-05-17 14:15:31Z dplugin $
 */

if(!defined('IN_DISCUZ')) {
	exit('Access Denied');
}

require DISCUZ_ROOT . 'api/payment/payment_base.php';

class payment_wechat extends payment_base {

	public function __construct() {
		global $_G;
		$this->plugin = unifiedpay_plugin_init('wechat');
		parent::__construct();
	}

	public function pay_jsapi($order, $openid) {
		return unifiedpay_plugin_call($this->plugin, __FUNCTION__, func_get_args());
	}

	public function pay_miniapp($order, $code) {
		return unifiedpay_plugin_call($this->plugin, __FUNCTION__, func_get_args());
	}

	public function wechat_jsapidata($jsapidata) {
		return json_encode($jsapidata);
	}

	public function wechat_authorize($redirect_uri, $state) {
		return unifiedpay_plugin_call($this->plugin, __FUNCTION__, func_get_args());
	}

	public function wechat_access_token_by_code($code) {
		return unifiedpay_plugin_call($this->plugin, __FUNCTION__, func_get_args());
	}

	public function v3_wechat_support() {
		if(function_exists('sodium_crypto_aead_aes256gcm_is_available') && sodium_crypto_aead_aes256gcm_is_available()) {
			return true;
		}
		if(PHP_VERSION_ID >= 70100 && in_array('aes-256-gcm', openssl_get_cipher_methods())) {
			return true;
		}
		return false;
	}

}