<?php
if(!defined('IN_DISCUZ')) {
    exit('Access Denied');
}
global $_G;

$out_biz_no = daddslashes($_GET['out_biz_no']);
if(!$out_biz_no) {
    exit(json_encode(['code'=>-1, 'msg'=>lang('message', 'payment_order_no_exist')]));
}
$code = isset($_GET['code'])?trim($_GET['code']):exit(json_encode(['code'=>-1, 'msg'=>'code no exist']));
$type = isset($_GET['type'])?trim($_GET['type']):'wechat';

$order = C::t('common_payment_order')->fetch_by_biz_no($out_biz_no);
if(!$order || $order['expire_time'] < time()) {
	exit(json_encode(['code'=>-1, 'msg'=>lang('message', 'payment_order_no_exist')]));
}
if($order['status']) {
    exit(json_encode(['code'=>-1, 'msg'=>lang('message', 'payment_succeed')]));
}

$payclass = payment::get($type);
if(!$payclass || !method_exists($payclass, 'pay_miniapp')) {
    exit(json_encode(['code'=>-1, 'msg'=>lang('message', 'payment_type_no_exist')]));
}

$result = $payclass->pay_miniapp($order, $code);
if($result['code'] != 200) {
    exit(json_encode(['code'=>-1, 'msg'=>$result['message']]));
}

exit(json_encode(['code'=>0, 'data'=>$result['url']]));
