<?php

namespace unifiedpay\plugins;
use Exception;
use unifiedpay\plugins\lib\WoaizfClient;

require dirname(__FILE__)."/lib/WoaizfClient.php";

class Woaizf
{
	static public $info = [
		'name' => 'woaizf',
		'sort' => 5,
		'link' => 'https://www.52zhifu.com/',
		'types' => ['alipay', 'wechat', 'qpay'],
		'inputs' => [
			'product_alipay' => [
				'name' => 'woaizf_product_alipay',
				'type' => 'mcheckbox',
				'note' => 'woaizf_product_comment',
				'select' => [
					['1', '支付宝扫码'],
					['2', '支付宝PC'],
					['3', '支付宝WAP'],
				],
			],
			'product_wechat' => [
				'name' => 'woaizf_product_wechat',
				'type' => 'mcheckbox',
				'note' => 'woaizf_product_comment',
				'select' => [
					['1', '微信扫码'],
					['2', '微信公众号'],
					['3', '微信H5'],
				],
			],
			'appid' => [
				'name' => 'woaizf_appid',
				'type' => 'text',
				'note' => '',
			],
			'appkey' => [
				'name' => 'woaizf_appkey',
				'type' => 'text',
				'note' => '',
			],
			'apiurl' => [
				'name' => 'diy_apiurl',
				'type' => 'text',
				'note' => 'woaizf_apiurl_comment',
			],
		],
	];

	public $channel;
	private $settings;
	public function __construct() {
		global $_G;
		$this->settings = $this->getConfig();
	}

	private function getConfig() {
		$settings = \C::t('common_setting')->fetch_setting('unifiedpay_woaizf', true);
		return $settings;
	}

	public function pay($order) {
		global $_G;
		\C::t('common_payment_order')->update($order['id'], array('channel' => $this->channel, 'plugin' => 'woaizf'));
		if($this->channel == 'alipay') {
			if(defined('IN_MOBILE') && in_array('3', $this->settings['product_alipay'])) {
				$pay_type = 'ALIPAY_WAP';
			}elseif(!defined('IN_MOBILE') && in_array('2', $this->settings['product_alipay'])) {
				$pay_type = 'ALIPAY_PC';
			}else{
				$pay_type = 'ALIPAY_QR';
			}
		}elseif($this->channel == 'wechat') {
			if(strpos($_SERVER['HTTP_USER_AGENT'], 'MicroMessenger')!==false && in_array('2', $this->settings['product_wechat'])){
				return $this->wechat_jspay($order);
			}elseif(defined('IN_MOBILE') && in_array('3', $this->settings['product_wechat'])) {
				$pay_type = 'WECHAT_H5';
			}else{
				$pay_type = 'WECHAT_QR';
			}
		}elseif($this->channel == 'qpay'){
			$pay_type = 'QQPAY_QR';
		}elseif($this->channel == 'bank'){
			$pay_type = 'BANK_QR';
		}
		try{
			$result = $this->addOrder($order, $pay_type);
			if($result['type'] == 'redirect_url'){
				return array('code' => 200, 'type' => 'jump', 'url' => $result['param']);
			}elseif($result['type'] == 'form'){
				return array('code' => 200, 'type' => 'html', 'url' => $result['param']);
			}elseif($result['type'] == 'urlscheme'){
				return array('code' => 200, 'type' => 'scheme', 'url' => $result['param']);
			}else{
				return array('code' => 200, 'type' => 'qrcode', 'url' => $result['param']);
			}
		}catch(Exception $e){
			$errmsg = $e->getMessage();
			if($errmsg && strtoupper($_G['charset'] != 'UTF-8')) {
				$errmsg = diconv($errmsg, 'UTF-8', $_G['charset']);
			}
			return array('code' => 501, 'message' => $errmsg);
		}
	}

	//通用创建订单
	private function addOrder($order, $pay_type, $openid = null){
		global $_G;
		if(strtoupper($_G['charset'] != 'UTF-8')) {
			$order['subject'] = diconv($order['subject'], $_G['charset'], 'UTF-8');
		}
		$param = [
			'channel' => $pay_type,
			'money' => sprintf('%.2f', $order['amount'] / 100),
			'client_ip' => $_G['clientip'],
			'name' => $order['subject'],
			'out_trade_no' => $order['out_biz_no'],
			'notify_url' => $_G['siteurl'] . 'api/payment/notify/notify_woaizf.php'
		];
		if($openid){
			$param['openid'] = $openid;
		}
		$client = new WoaizfClient($this->settings);
		return $client->payment_create($param);
	}

	//微信JSAPI支付
	public function pay_jsapi($order, $openid) {
		global $_G;
		try{
			$result = $this->addOrder($order, 'WECHAT_JSAPI', $openid);
			return array('code' => 200, 'url' => json_decode($result['param'], true));
		}catch(Exception $e){
			$errmsg = $e->getMessage();
			if($errmsg && strtoupper($_G['charset'] != 'UTF-8')) {
				$errmsg = diconv($errmsg, 'UTF-8', $_G['charset']);
			}
			return array('code' => 501, 'message' => $errmsg);
		}
	}

	//微信小程序支付
	public function pay_miniapp($order, $code) {
		global $_G;

		$wxinfo = \C::t('common_setting')->fetch_setting('unifiedpay_wechat', true);
		try{
			$tools = new \WeChatPay\JsApiTool($wxinfo['miniappid'], $wxinfo['miniappsecret']);
			$openid = $tools->AppGetOpenid($code);
		}catch(Exception $e){
			$errmsg = $e->getMessage();
			if($errmsg && strtoupper($_G['charset'] != 'UTF-8')) {
				$errmsg = diconv($errmsg, 'UTF-8', $_G['charset']);
			}
			return array('code' => 501, 'message' => $errmsg);
		}

		try{
			$result = $this->addOrder($order, 'WECHAT_LITE', $openid);
			return array('code' => 200, 'url' => json_decode($result['param'], true));
		}catch(Exception $e){
			$errmsg = $e->getMessage();
			if($errmsg && strtoupper($_G['charset'] != 'UTF-8')) {
				$errmsg = diconv($errmsg, 'UTF-8', $_G['charset']);
			}
			return array('code' => 501, 'message' => $errmsg);
		}
	}

	//微信公众号支付
	private function wechat_jspay($order) {
		global $_G;

		$wxinfo = \C::t('common_setting')->fetch_setting('unifiedpay_wechat', true);
		try{
			$tools = new \WeChatPay\JsApiTool($wxinfo['appid'], $wxinfo['appsecret']);
			$openid = $tools->GetOpenid();
		}catch(Exception $e){
			$errmsg = $e->getMessage();
			if($errmsg && strtoupper($_G['charset'] != 'UTF-8')) {
				$errmsg = diconv($errmsg, 'UTF-8', $_G['charset']);
			}
			return array('code' => 501, 'message' => $errmsg);
		}

		$result = $this->pay_jsapi($order, $openid);
		if($result['code'] == 200){
			$result['type'] = 'wxjspay';
		}
		return $result;
	}

	public function status($out_biz_no) {
		return array('code' => 500, 'message' => lang('plugin/unifiedpay', 'payment_channel_not_support'));
	}

	public function refund($refund_no, $trade_no, $total_amount, $refund_amount, $refund_desc) {
		global $_G;
		$param = [
			'trade_no' => $trade_no,
			'money' => sprintf('%.2f', $refund_amount / 100)
		];
		try{
			$client = new WoaizfClient($this->settings);
			$client->refund_confirm($param);
			return array('code' => 200, 'data' => array('refund_time' => time()));
		}catch(Exception $e){
			$errmsg = $e->getMessage();
			if($errmsg && strtoupper($_G['charset'] != 'UTF-8')) {
				$errmsg = diconv($errmsg, 'UTF-8', $_G['charset']);
			}
			return array('code' => 501, 'message' => $errmsg);
		}
	}

	public function refund_status($refund_no, $trade_no) {
		return array('code' => 200, 'data' => array('refund_time' => time()));
	}

	public function notify() {
		if(!isset($_POST)) {
			exit('data_fail');
		}

		$client = new WoaizfClient($this->settings);
		$verify_result = $client->verify($_POST);
		if(!$verify_result) {
			exit('sign_fail');
		}
		
		$out_biz_no = $_POST['out_trade_no'];
		unifiedpay_process_notify($out_biz_no, $_POST['trade_no']);
		exit('success');
	}
}