<?php

namespace unifiedpay\plugins;
use Exception;
use unifiedpay\plugins\lib\XunhupayClient;

require_once dirname(__FILE__)."/lib/XunhupayClient.php";

class Xunhupay
{
	static public $info = [
		'name' => 'xunhupay',
		'sort' => 6,
		'link' => 'https://www.xunhupay.com/',
		'types' => ['alipay'],
		'inputs' => [
			'appid' => [
				'name' => 'AppID',
				'type' => 'text',
				'note' => '',
			],
			'appsecret' => [
				'name' => 'AppSecret',
				'type' => 'text',
				'note' => '',
			],
			'apiurl' => [
				'name' => 'diy_apiurl',
				'type' => 'text',
				'note' => 'xunhupay_apiurl_comment',
			],
		],
	];

	public $channel;
	private $settings;
	public function __construct() {
		global $_G;
		$this->settings = $this->getConfig();
	}

	private function getConfig() {
		$settings = \C::t('common_setting')->fetch_setting('unifiedpay_xunhupay', true);
		return $settings;
	}

	public function pay($order) {
		global $_G;
		\C::t('common_payment_order')->update($order['id'], array('channel' => $this->channel, 'plugin' => 'xunhupay'));
		try{
			$result = $this->addOrder($order);
			if(defined('IN_MOBILE')){
				return array('code' => 200, 'type' => 'jump', 'url' => $result['url']);
			}else{
				$client = new XunhupayClient($this->settings);
				$code_url = $client->parseQrcode($result['url_qrcode']);
				return array('code' => 200, 'type' => 'qrcode', 'url' => $code_url);
			}
		}catch(Exception $e){
			$errmsg = $e->getMessage();
			if($errmsg && strtoupper($_G['charset'] != 'UTF-8')) {
				$errmsg = diconv($errmsg, 'UTF-8', $_G['charset']);
			}
			return array('code' => 501, 'message' => $errmsg);
		}
	}

	//通用创建订单
	private function addOrder($order){
		global $_G;
		if(strtoupper($_G['charset'] != 'UTF-8')) {
			$order['subject'] = diconv($order['subject'], $_G['charset'], 'UTF-8');
		}
		$param = [
			'version'   => '1.1',
			'trade_order_id'=> $order['out_biz_no'],
			'payment'   => 'alipay',
			'total_fee' => sprintf('%.2f', $order['amount'] / 100),
			'title'     => $order['subject'],
			'notify_url'=>  $_G['siteurl'] . 'api/payment/notify/notify_xunhupay.php',
			'return_url'=> $order['return_url'],
		];
		$client = new XunhupayClient($this->settings);
		return $client->do_payment($param);
	}

	public function status($out_biz_no) {
		global $_G;
		$param = [
			'out_trade_order' => $out_biz_no
		];
		try{
			$client = new XunhupayClient($this->settings);
			$result = $client->do_payment($param);
			if($result['data']['status'] == 'OD') {
				return array('code' => 200, 'data' => array('trade_no' => $result['data']['open_order_id'], 'payment_time' => time()));
			}else{
				return array('code' => 500, 'message' => '未支付');
			}
		}catch(Exception $e){
			$errmsg = $e->getMessage();
			if($errmsg && strtoupper($_G['charset'] != 'UTF-8')) {
				$errmsg = diconv($errmsg, 'UTF-8', $_G['charset']);
			}
			return array('code' => 501, 'message' => $errmsg);
		}
	}

	public function refund($refund_no, $trade_no, $total_amount, $refund_amount, $refund_desc) {
		global $_G;
		$param = [
			'open_order_id' => $trade_no
		];
		try{
			$client = new XunhupayClient($this->settings);
			$result = $client->do_refund($param);
			return array('code' => 200, 'data' => array('refund_time' => time()));
		}catch(Exception $e){
			$errmsg = $e->getMessage();
			if($errmsg && strtoupper($_G['charset'] != 'UTF-8')) {
				$errmsg = diconv($errmsg, 'UTF-8', $_G['charset']);
			}
			return array('code' => 501, 'message' => $errmsg);
		}
	}

	public function notify() {
		if(!isset($_POST) || !isset($_POST['hash']) || !isset($_POST['trade_order_id'])) {
			exit('data_fail');
		}

		$client = new XunhupayClient($this->settings);
		$verify_result = $client->verify($_POST);
		if(!$verify_result) {
			exit('sign_fail');
		}
		
		if($_POST['status']=='OD'){
			$out_biz_no = $_POST['trade_order_id'];
			unifiedpay_process_notify($out_biz_no, $_POST['open_order_id']);
			exit('success');
		}
		exit('fail');
	}
}